<?php
include_once 'connection.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id']) && isset($_POST['presence'])) {
    $id = $_POST['id'];
    $presence = $_POST['presence'];

    // Atualiza a presença no banco de dados
    $stmt = $pdo->prepare("UPDATE quadro SET presenca = ? WHERE id = ?");
    $stmt->execute([$presence, $id]);

    // Prepara a mensagem de log
    $dataAtual = date('H:i:s d/m/Y'); // Formato desejado: hh:mm:ss dd/mm/aaaa

    // Consulta para pegar o posto, corpo e nome do usuário
    $stmtUser = $pdo->prepare("SELECT posto, corpo, nome FROM quadro WHERE id = ?");
    $stmtUser->execute([$id]);
    $user = $stmtUser->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        // Concatena posto, corpo e nome
        $corpo = $user['corpo'];
        $alteracao = "{$user['posto']} {$corpo} {$user['nome']} " . ($presence == 1 ? "CHEGOU A BORDO" : "BAIXOU TERRA") . " ÀS {$dataAtual}";

        // Insere registro no log
        $logStmt = $pdo->prepare("INSERT INTO log (alteracao, data) VALUES (?, ?)");
        $logStmt->execute([$alteracao, $dataAtual]);

        // Retorna a mensagem de log
        echo $alteracao;
    } else {
        echo "Usuário não encontrado.";
    }
} else {
    echo "Dados inválidos.";
}
?>
