<?php
require 'connection.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['salvar'])) {
    $id = $_POST['id'];
    $posto = $_POST['posto'];
    $corpo = $_POST['corpo'];
    $nome = $_POST['nome'];
    $ala = $_POST['ala'];
    $presenca = $_POST['presenca'];
    $antiguidade_ala = $_POST['antiguidade_ala'];
    $antiguidade_geral = $_POST['antiguidade_geral'];

    $stmt = $pdo->prepare("UPDATE quadro SET posto=?, corpo=?, nome=?, ala=?, presenca=?, antiguidade_ala=?, antiguidade_geral=? WHERE id=?");
    $stmt->execute([$posto, $corpo, $nome, $ala, $presenca, $antiguidade_ala, $antiguidade_geral, $id]);
}

$sql = "SELECT * FROM quadro";
if ($result = $pdo->query($sql)) {
    $dados = $result->fetchAll(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista Quadro</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        .img-circle {
            border-radius: 50%;
            width: 100px;
            height: 100px;
            object-fit: cover;
        }
    </style>
</head>
<body>
<div class="container mt-5">
    <h2>Lista Quadro</h2>
    <table class="table">
        <thead>
        <tr>
            <th>Imagem</th>
            <th>Posto</th>
            <th>Corpo</th>
            <th>Nome</th>
            <th>Ala</th>
            <th>Presença</th>
            <th>Antiguidade Ala</th>
            <th>Antiguidade Geral</th>
            <th>Ações</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($dados as $d): ?>
            <tr>
                <td><img src="imagens/<?php echo htmlspecialchars($d['imagem']); ?>" class="img-circle" alt="Imagem"></td>
                <form method="POST" action="">
                    <input type="hidden" name="id" value="<?php echo $d['id']; ?>">
                    <td><input type="text" name="posto" value="<?php echo htmlspecialchars($d['posto']); ?>" class="form-control"></td>
                    <td><input type="text" name="corpo" value="<?php echo htmlspecialchars($d['corpo']); ?>" class="form-control"></td>
                    <td><input type="text" name="nome" value="<?php echo htmlspecialchars($d['nome']); ?>" class="form-control"></td>
                    <td><input type="text" name="ala" value="<?php echo htmlspecialchars($d['ala']); ?>" class="form-control"></td>
                    <td><input type="text" name="presenca" value="<?php echo htmlspecialchars($d['presenca']); ?>" class="form-control"></td>
                    <td><input type="text" name="antiguidade_ala" value="<?php echo htmlspecialchars($d['antiguidade_ala']); ?>" class="form-control"></td>
                    <td><input type="text" name="antiguidade_geral" value="<?php echo htmlspecialchars($d['antiguidade_geral']); ?>" class="form-control"></td>
                    <td>
                        <button type="submit" name="salvar" class="btn btn-primary">Salvar</button>
                    </td>
                </form>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>

    <h3>Inserir Novo Dado</h3>
    <form method="POST" action="upload.php" enctype="multipart/form-data">
        <div class="form-group">
            <label for="posto">Posto:</label>
            <input type="text" name="posto" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="corpo">Corpo:</label>
            <input type="text" name="corpo" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="nome">Nome:</label>
            <input type="text" name="nome" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="ala">Ala:</label>
            <input type="text" name="ala" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="presenca">Presença:</label>
            <input type="text" name="presenca" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="antiguidade_ala">Antiguidade Ala:</label>
            <input type="text" name="antiguidade_ala" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="antiguidade_geral">Antiguidade Geral:</label>
            <input type="text" name="antiguidade_geral" class="form-control" required>
        </div>
        <div class="form-group">
            <label for="imagem">Imagem (PNG):</label>
            <input type="file" name="imagem" accept=".png" class="form-control" required>
        </div>
        <button type="submit" class="btn btn-success">Adicionar</button>
    </form>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
