<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inserir Eventos em Massa</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(to bottom, #4682b4, #87cefa); /* Azul claro */
            color: white;
        }
        .container {
            margin-top: 20px;
        }
        .calendar-table {
            width: 100%;
            table-layout: fixed;
            margin-bottom: 20px;
        }
        .calendar-table th, .calendar-table td {
            text-align: center;
            border: 1px solid #fff;
            padding: 5px;
            vertical-align: middle;
        }
        .calendar-table th {
            background-color: #1e3a8a; /* Azul escuro */
        }
        .calendar-table td {
            background-color: #4682b4; /* Azul claro */
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="text-center">Inserir Eventos em Massa</h1>
        <form id="eventForm" action="insert_events.php" method="POST">
            <div class="form-group">
                <label for="eventType">Selecione o Tipo de Evento:</label>
                <select class="form-control" id="eventType" name="eventType" required>
                    <option value="" disabled selected hidden>Selecione o Tipo de Evento</option>
                    <option value="VIDEOCONFERÊNCIA">Apoio VC</option>
                    <option value="LIC-PG">LIC-PG</option>
                    <option value="AUDITÓRIO">AUDITÓRIO</option>
                    <option value="REUNIÃO">REUNIÃO</option>
                    <option value="CERIMÔNIA">CERIMÔNIA</option>
                    <option value="EVENTO">EVENTO</option>
                    <option value="OUTROS">OUTROS</option>
                    
                </select>
            </div>

            <div class="form-group">
                <label for="eventColor">Selecione a Cor do Evento:</label>
                <select class="form-control" id="eventColor" name="eventColor" required>
                    <option value="" disabled selected hidden>Selecione a Cor</option>
                    <option value="#FF5733" style="background-color: #FF5733;">Vermelho</option>
                    <option value="#FFBD33" style="background-color: #FFBD33;">Amarelo</option>
                    <option value="#33FF57" style="background-color: #33FF57;">Verde</option>
                    <option value="#33FFBD" style="background-color: #33FFBD;">Ciano</option>
                    <option value="#3357FF" style="background-color: #3357FF;">Azul</option>
                    <option value="#5733FF" style="background-color: #5733FF;">Roxo</option>
                    <option value="#FF33A1" style="background-color: #FF33A1;">Rosa</option>
                    <option value="#FF8C33" style="background-color: #FF8C33;">Laranja</option>
                    <option value="#FFD700" style="background-color: #FFD700;">Ouro</option>
                    <option value="#ADFF2F" style="background-color: #ADFF2F;">Verde Limão</option>
                    <option value="#00BFFF" style="background-color: #00BFFF;">Azul Céu</option>
                    <option value="#9370DB" style="background-color: #9370DB;">Roxo Claro</option>
                </select>
            </div>

            <div class="form-group">
                <label for="eventDays">Selecione os Dias:</label>
                <?php
                // Exibe o calendário dos próximos 6 meses
                $monthNames = [
                    'January' => 'Janeiro',
                    'February' => 'Fevereiro',
                    'March' => 'Março',
                    'April' => 'Abril',
                    'May' => 'Maio',
                    'June' => 'Junho',
                    'July' => 'Julho',
                    'August' => 'Agosto',
                    'September' => 'Setembro',
                    'October' => 'Outubro',
                    'November' => 'Novembro',
                    'December' => 'Dezembro'
                ];

                $currentDate = new DateTime();
                for ($i = 0; $i < 6; $i++) {
                    $firstDayOfMonth = (clone $currentDate)->modify("+$i month")->modify('first day of this month');
                    $lastDayOfMonth = (clone $firstDayOfMonth)->modify('last day of this month');

                    echo '<h4>' . $monthNames[$firstDayOfMonth->format('F')] . ' ' . $firstDayOfMonth->format('Y') . '</h4>';
                    echo '<table class="calendar-table">';
                    echo '<thead><tr>';
                    echo '<th>Dom</th><th>Seg</th><th>Ter</th><th>Qua</th><th>Qui</th><th>Sex</th><th>Sab</th>';
                    echo '</tr></thead><tbody><tr>';

                    // Preencher o início com células vazias
                    for ($j = 1; $j < $firstDayOfMonth->format('N'); $j++) {
                        echo '<td></td>';
                    }

                    // Preencher os dias do mês
                    for ($day = 1; $day <= $lastDayOfMonth->format('d'); $day++) {
                        $currentDay = $firstDayOfMonth->format('Y-m-') . str_pad($day, 2, '0', STR_PAD_LEFT);
                        echo '<td><input type="checkbox" name="eventDays[]" value="' . $currentDay . '"> ' . $day . '</td>';

                        // Quebra de linha após sábado
                        if ($firstDayOfMonth->format('N') == 7) {
                            echo '</tr><tr>';
                        }
                        $firstDayOfMonth->modify('+1 day');
                    }

                    // Preencher o final com células vazias
                    while ($firstDayOfMonth->format('N') != 1) {
                        echo '<td></td>';
                        $firstDayOfMonth->modify('+1 day');
                    }

                    echo '</tr></tbody></table>';
                }
                ?>
            </div>

            <div class="form-group">
                <label for="startTime">Horário de Início:</label>
                <input type="time" class="form-control" id="startTime" name="startTime" required>
            </div>
            <div class="form-group">
                <label for="endTime">Horário de Término:</label>
                <input type="time" class="form-control" id="endTime" name="endTime" required>
            </div>
            <div class="form-group">
                <label for="description">Descrição:</label>
                <textarea class="form-control" id="description" name="description" rows="3" required></textarea>
            </div>
            <button type="submit" class="btn btn-primary">Inserir Eventos</button>
        </form>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
</body>
</html>
